/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.arcticmobs.worldgen;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.arcticmobs.ArcticMobs;
import com.lycanitesmobs.core.IWorldGenBase;
import com.lycanitesmobs.core.config.ConfigSpawning;
import com.lycanitesmobs.core.info.GroupInfo;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraftforge.common.BiomeDictionary;

public class WorldGenOozeLakes
extends WorldGenLakes
implements IWorldGenBase {
    public String name = "Ooze Lakes";
    public GroupInfo group = ArcticMobs.group;
    public double generateUndergroundChance = 0.04;
    public double generateSurfaceChance = 0.125;
    public String dimensionEntries = "-1, 1";
    public int[] dimensionBlacklist;
    public String[] dimensionTypes;
    public boolean dimensionWhitelist = false;

    public WorldGenOozeLakes() {
        super(ObjectManager.getBlock("ooze"));
        ConfigSpawning config = ConfigSpawning.getConfig(this.group, "worldgen");
        config.setCategoryComment("WorldGen Chances", "The chance that each worldgen will generate. You can set this to 0 to disable the worldgen or use the dimension black/white list. 1 = all over, 0.04 fairly rare.");
        this.generateUndergroundChance = config.getDouble("WorldGen Chances", this.name + " Underground Chance", this.generateUndergroundChance);
        this.generateSurfaceChance = config.getDouble("WorldGen Chances", this.name + " Surface Chance", this.generateSurfaceChance, "Ooze only generates on the surface when in COLD and SNOWY tagged biomes.");
        ConfigSpawning.SpawnDimensionSet dimensions = config.getDimensions("WorldGen Dimensions", this.name + " Dimensions", this.dimensionEntries);
        this.dimensionBlacklist = dimensions.dimensionIDs;
        this.dimensionTypes = dimensions.dimensionTypes;
        this.dimensionWhitelist = config.getBool("WorldGen Dimensions", this.name + " Dimensions Whitelist Mode", this.dimensionWhitelist);
    }

    @Override
    public void onWorldGen(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int z;
        int x;
        int top;
        if (!this.isValidDimension(world)) {
            return;
        }
        if (this.generateSurfaceChance > 0.0) {
            Biome biome = world.func_180494_b(new BlockPos(chunkX * 16, 0, chunkZ * 16));
            if (biome == null) {
                return;
            }
            BiomeDictionary.Type[] biomeTypes = BiomeDictionary.getTypesForBiome((Biome)biome);
            boolean typeValid = false;
            for (BiomeDictionary.Type type : biomeTypes) {
                if (type != BiomeDictionary.Type.SNOWY && type != BiomeDictionary.Type.COLD) continue;
                typeValid = true;
                break;
            }
            if (typeValid && (this.generateSurfaceChance >= 1.0 || random.nextDouble() <= this.generateSurfaceChance)) {
                int x2 = chunkX * 16 + 8;
                int z2 = chunkZ * 16 + 8;
                int y = random.nextInt(128);
                this.func_180709_b(world, random, new BlockPos(x2, y, z2));
            }
        }
        if (this.generateUndergroundChance > 0.0 && (this.generateUndergroundChance >= 1.0 || random.nextDouble() <= this.generateUndergroundChance) && (top = Math.max(1, world.func_175672_r(new BlockPos(x = chunkX * 16 + 8, 0, z = chunkZ * 16 + 8)).func_177956_o() - 10)) > 0) {
            int y = random.nextInt(top);
            this.func_180709_b(world, random, new BlockPos(x, y, z));
        }
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        return super.func_180709_b(world, random, pos);
    }

    public boolean isValidDimension(World world) {
        boolean validDimension = false;
        for (String eventDimensionType : this.dimensionTypes) {
            if ("ALL".equalsIgnoreCase(eventDimensionType)) {
                validDimension = true;
                continue;
            }
            if (!"VANILLA".equalsIgnoreCase(eventDimensionType)) continue;
            validDimension = world.field_73011_w.getDimension() > -2 && world.field_73011_w.getDimension() < 2;
        }
        if (!validDimension) {
            validDimension = !this.dimensionWhitelist;
            for (int eventDimension : this.dimensionBlacklist) {
                if (world.field_73011_w.getDimension() != eventDimension) continue;
                validDimension = this.dimensionWhitelist;
                break;
            }
        }
        return validDimension;
    }
}

